
# Order Line Item

Represents a line item in an order. Each line item describes a different
product to purchase, with its own quantity and price details.

## Structure

`OrderLineItem`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the line item only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `name` | `?string` | Optional | The name of the line item.<br>**Constraints**: *Maximum Length*: `512` | getName(): ?string | setName(?string name): void |
| `quantity` | `string` | Required | The quantity purchased, formatted as a decimal number.<br>For example, `"3"`.<br><br>Line items with a quantity of `"0"` are automatically removed<br>when paying for or otherwise completing the order.<br><br>Line items with a `quantity_unit` can have non-integer quantities.<br>For example, `"1.70000"`.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `12` | getQuantity(): string | setQuantity(string quantity): void |
| `quantityUnit` | [`?OrderQuantityUnit`](../../doc/models/order-quantity-unit.md) | Optional | Contains the measurement unit for a quantity and a precision that<br>specifies the number of digits after the decimal point for decimal quantities. | getQuantityUnit(): ?OrderQuantityUnit | setQuantityUnit(?OrderQuantityUnit quantityUnit): void |
| `note` | `?string` | Optional | The note of the line item.<br>**Constraints**: *Maximum Length*: `2000` | getNote(): ?string | setNote(?string note): void |
| `catalogObjectId` | `?string` | Optional | The [CatalogItemVariation](../../doc/models/catalog-item-variation.md) ID applied to this line item.<br>**Constraints**: *Maximum Length*: `192` | getCatalogObjectId(): ?string | setCatalogObjectId(?string catalogObjectId): void |
| `catalogVersion` | `?int` | Optional | The version of the catalog object that this line item references. | getCatalogVersion(): ?int | setCatalogVersion(?int catalogVersion): void |
| `variationName` | `?string` | Optional | The name of the variation applied to this line item.<br>**Constraints**: *Maximum Length*: `400` | getVariationName(): ?string | setVariationName(?string variationName): void |
| `itemType` | [`?string (OrderLineItemItemType)`](../../doc/models/order-line-item-item-type.md) | Optional | Represents the line item type. | getItemType(): ?string | setItemType(?string itemType): void |
| `metadata` | `?array<string,string>` | Optional | Application-defined data attached to this line item. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |
| `modifiers` | [`?(OrderLineItemModifier[])`](../../doc/models/order-line-item-modifier.md) | Optional | The [CatalogModifier](../../doc/models/catalog-modifier.md)s applied to this line item. | getModifiers(): ?array | setModifiers(?array modifiers): void |
| `appliedTaxes` | [`?(OrderLineItemAppliedTax[])`](../../doc/models/order-line-item-applied-tax.md) | Optional | The list of references to taxes applied to this line item. Each<br>`OrderLineItemAppliedTax` has a `tax_uid` that references the `uid` of a<br>top-level `OrderLineItemTax` applied to the line item. On reads, the<br>amount applied is populated.<br><br>An `OrderLineItemAppliedTax` is automatically created on every line<br>item for all `ORDER` scoped taxes added to the order. `OrderLineItemAppliedTax`<br>records for `LINE_ITEM` scoped taxes must be added in requests for the tax<br>to apply to any line items.<br><br>To change the amount of a tax, modify the referenced top-level tax. | getAppliedTaxes(): ?array | setAppliedTaxes(?array appliedTaxes): void |
| `appliedDiscounts` | [`?(OrderLineItemAppliedDiscount[])`](../../doc/models/order-line-item-applied-discount.md) | Optional | The list of references to discounts applied to this line item. Each<br>`OrderLineItemAppliedDiscount` has a `discount_uid` that references the `uid` of a top-level<br>`OrderLineItemDiscounts` applied to the line item. On reads, the amount<br>applied is populated.<br><br>An `OrderLineItemAppliedDiscount` is automatically created on every line item for all<br>`ORDER` scoped discounts that are added to the order. `OrderLineItemAppliedDiscount` records<br>for `LINE_ITEM` scoped discounts must be added in requests for the discount to apply to any<br>line items.<br><br>To change the amount of a discount, modify the referenced top-level discount. | getAppliedDiscounts(): ?array | setAppliedDiscounts(?array appliedDiscounts): void |
| `basePriceMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getBasePriceMoney(): ?Money | setBasePriceMoney(?Money basePriceMoney): void |
| `variationTotalPriceMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getVariationTotalPriceMoney(): ?Money | setVariationTotalPriceMoney(?Money variationTotalPriceMoney): void |
| `grossSalesMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getGrossSalesMoney(): ?Money | setGrossSalesMoney(?Money grossSalesMoney): void |
| `totalTaxMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getTotalTaxMoney(): ?Money | setTotalTaxMoney(?Money totalTaxMoney): void |
| `totalDiscountMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getTotalDiscountMoney(): ?Money | setTotalDiscountMoney(?Money totalDiscountMoney): void |
| `totalMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getTotalMoney(): ?Money | setTotalMoney(?Money totalMoney): void |
| `pricingBlocklists` | [`?OrderLineItemPricingBlocklists`](../../doc/models/order-line-item-pricing-blocklists.md) | Optional | Describes pricing adjustments that are blocked from manual and<br>automatic application to a line item. For more information, see<br>[Apply Taxes and Discounts](https://developer.squareup.com/docs/orders-api/apply-taxes-and-discounts). | getPricingBlocklists(): ?OrderLineItemPricingBlocklists | setPricingBlocklists(?OrderLineItemPricingBlocklists pricingBlocklists): void |

## Example (as JSON)

```json
{
  "uid": "uid0",
  "name": "name0",
  "quantity": "quantity6",
  "quantity_unit": {
    "measurement_unit": {
      "custom_unit": {
        "name": "name8",
        "abbreviation": "abbreviation0"
      },
      "area_unit": "IMPERIAL_SQUARE_FOOT",
      "length_unit": "METRIC_METER",
      "volume_unit": "GENERIC_CUP",
      "weight_unit": "IMPERIAL_WEIGHT_OUNCE"
    },
    "precision": 54,
    "catalog_object_id": "catalog_object_id0",
    "catalog_version": 12
  },
  "note": "note4",
  "catalog_object_id": "catalog_object_id6"
}
```

